@extends('layouts.admin')

@section('title', 'View Testimonial')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">View Testimonial</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.testimonials.edit', $testimonial) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.testimonials.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="mb-3">
            <strong>Author:</strong>
            <p>{{ $testimonial->author }}</p>
        </div>

        <div class="mb-3">
            <strong>Rating:</strong>
            <p>
                @for($i = 1; $i <= 5; $i++)
                    <i class="bi bi-star{{ $i <= $testimonial->rating ? '-fill text-warning' : '' }}"></i>
                @endfor
                ({{ $testimonial->rating }}/5)
            </p>
        </div>

        <div class="mb-3">
            <strong>Content:</strong>
            <p class="mt-2">{{ $testimonial->content }}</p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <strong>Status:</strong>
                <p>
                    <span class="badge bg-{{ $testimonial->is_active ? 'success' : 'secondary' }}">
                        {{ $testimonial->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <strong>Sort Order:</strong>
                <p>{{ $testimonial->sort_order }}</p>
            </div>
        </div>

        <hr>

        <p><strong>Created:</strong> {{ $testimonial->created_at->format('M d, Y h:i A') }}</p>
        <p><strong>Last Updated:</strong> {{ $testimonial->updated_at->format('M d, Y h:i A') }}</p>
    </div>
</div>
@endsection



